import process_results
import end_of_training_hpo
import sys


def turn_str_into_arg(str_dict):
    out = {}
    for arg in str_dict:
        out["--"+arg] = str_dict[arg]
    return out


if __name__ == '__main__':
    for i, arg in enumerate(sys.argv):
        if arg == "--model":
            method = sys.argv[i+1]
            break
    sys.argv += ['--nowand', '1']
    val_results = process_results.get_results("results/new_EOT")
    best_hpo_settings = process_results.get_best_eot_val_settings(val_results)
    for dataset in best_hpo_settings[method]:
        #for setting in best_hpo_settings[method][dataset]:
        setting = 'class-il'
        args = ["--dataset", dataset]
        args += ['--log_dir', 'results/eot_task_il_results/'] if setting == "task-il" else ['--log_dir', 'results/new_EOT_results/']
        end_of_training_hpo.run_exp(turn_str_into_arg(best_hpo_settings[method][dataset][setting]), base_args=sys.argv+args)

